/*
 * Decompiled with CFR 0.152.
 */
package com.roguewave.chart.overlay.core.v2_1;

import com.roguewave.chart.core.v2_1.ChartBuilder;
import com.roguewave.chart.core.v2_1.ChartGraphics;
import com.roguewave.chart.core.v2_1.ChartProperties;
import com.roguewave.chart.core.v2_1.DataModel;
import com.roguewave.chart.overlay.core.v2_1.AllRowsDataRange;
import com.roguewave.chart.overlay.core.v2_1.ChartOverlay;
import com.roguewave.chart.overlay.core.v2_1.DataRange;
import com.roguewave.chart.overlay.core.v2_1.Log10Scale;
import com.roguewave.chart.overlay.core.v2_1.ParameterCalculator;
import com.roguewave.chart.overlay.core.v2_1.ScaleConstants;
import com.roguewave.chart.richtext.v2_1.AlignedBlock;
import com.roguewave.chart.richtext.v2_1.ColorBlock;
import com.roguewave.chart.richtext.v2_1.FontBlock;
import com.roguewave.chart.richtext.v2_1.HTMLStyleParser;
import com.roguewave.chart.richtext.v2_1.TextBlock;
import com.roguewave.chart.richtext.v2_1.TextBlockDrawable;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.util.Vector;

public class OverlayChart
implements ChartBuilder,
ScaleConstants {
    private Vector overlays_ = new Vector();
    private DataRange dataRange1_ = null;
    private DataRange dataRange2_ = null;
    private Color color1_ = Color.blue;
    private Color color2_ = Color.green.darker();
    private ChartProperties internalProperties_ = new ChartProperties();
    private int itemWidth_ = 1;
    private int spaceWidth_ = 1;
    private int columnWidth_ = this.itemWidth_ + this.spaceWidth_;
    private Font titleFont_ = new Font("TimesRoman", 1, 18);
    private Font scaleFont_ = new Font("TimesRoman", 0, 10);
    private boolean scale1IsLinear_ = true;
    private boolean scale2IsLinear_ = true;
    private boolean ignorePrimaryAxis_ = false;
    private boolean ignoreSecondaryAxis_ = false;
    private int drawHeight_ = 0;
    private static final int titleHeight = 25;
    private static final int bottomMargin = 25;
    private static final int scaleWidth = 50;
    private Insets insets_ = new Insets(25, 50, 25, 50);

    public boolean supports(int viewMode) {
        return viewMode == 0;
    }

    public void addOverlay(ChartOverlay overlay) {
        this.overlays_.addElement(overlay);
        if (overlay.getItemWidth() > this.itemWidth_) {
            this.itemWidth_ = overlay.getItemWidth();
            this.columnWidth_ = this.itemWidth_ + this.spaceWidth_;
        }
    }

    public void setLog10Scale(boolean scale, boolean value) {
        if (scale) {
            this.scale1IsLinear_ = !value;
        } else {
            this.scale2IsLinear_ = !value;
        }
    }

    public int getSpaceWidth() {
        return this.spaceWidth_;
    }

    public void setSpaceWidth(int width) {
        this.spaceWidth_ = width;
        this.columnWidth_ = this.itemWidth_ + this.spaceWidth_;
    }

    public ChartGraphics build(ChartProperties properties, DataModel data) {
        ChartGraphics chartGraphics = new ChartGraphics();
        int dataPoints = data.getColumnCount();
        Font labelFont = new Font("TimesRoman", 0, 10);
        labelFont = (Font)properties.getProperty("scale2DFont", labelFont);
        Color labelColor = (Color)properties.getProperty("scaleColor", Color.black);
        String titleText = (String)properties.getProperty("title", data.getName());
        TextBlock titleBlock = HTMLStyleParser.parse(titleText, null);
        titleBlock = new FontBlock(titleBlock, this.titleFont_);
        titleBlock = new AlignedBlock(titleBlock, 1);
        titleBlock = new ColorBlock(titleBlock, Color.black);
        int left = this.insets_.left;
        int right = left + dataPoints * this.columnWidth_ - this.spaceWidth_ + 1;
        int offset = this.itemWidth_ / 2 + 1;
        int pixelHeight = (int)(properties.getChartHeight() + 0.5);
        if (this.drawHeight_ - this.insets_.top - this.insets_.bottom > 10) {
            pixelHeight = this.drawHeight_ - this.insets_.top - this.insets_.bottom;
        }
        TextBlockDrawable title = new TextBlockDrawable(titleBlock, (left + right) / 2, 2, 0);
        int base = this.insets_.top + pixelHeight;
        chartGraphics.add2DDrawable(title);
        ParameterCalculator params1 = this.scale1IsLinear_ ? new ParameterCalculator(this.getDataRangeLow1(data), this.getDataRangeHigh1(data), this.getScaleIncrement1(data), pixelHeight) : new ParameterCalculator(this.getDataRangeLow1(data), this.getDataRangeHigh1(data), pixelHeight);
        ParameterCalculator params2 = this.scale2IsLinear_ ? new ParameterCalculator(this.getDataRangeLow2(data), this.getDataRangeHigh2(data), this.getScaleIncrement2(data), pixelHeight) : new ParameterCalculator(this.getDataRangeLow2(data), this.getDataRangeHigh2(data), pixelHeight);
        if (this.ignorePrimaryAxis_) {
            params1 = params2;
        }
        if (this.ignoreSecondaryAxis_) {
            params2 = params1;
        }
        if (!this.ignorePrimaryAxis_ && !this.ignoreSecondaryAxis_) {
            int multiple;
            int chart2Intervals;
            int chart1Intervals = params1.getHighIncrement() - params1.getLowIncrement();
            if (chart1Intervals > (chart2Intervals = params2.getHighIncrement() - params2.getLowIncrement())) {
                multiple = chart1Intervals / chart2Intervals;
                params2.recalculateWith(params1.getPixelsPerIncrement() * multiple);
            } else {
                multiple = chart2Intervals / chart1Intervals;
                params1.recalculateWith(params2.getPixelsPerIncrement() * multiple);
            }
        }
        for (int i = 0; i < this.overlays_.size(); ++i) {
            ChartOverlay overlay = (ChartOverlay)this.overlays_.elementAt(i);
            overlay.addTo(chartGraphics, data, base, left, right, offset, this.columnWidth_, params1, params2);
        }
        return chartGraphics;
    }

    public Color getPrimaryColor() {
        return this.color1_;
    }

    public void setPrimaryColor(Color color) {
        this.color1_ = color;
    }

    public Color getSecondaryColor() {
        return this.color2_;
    }

    public void setSecondaryColor(Color color) {
        this.color2_ = color;
    }

    public void setDataRange1(DataRange dataRange) {
        this.dataRange1_ = dataRange;
    }

    public void setDataRange2(DataRange dataRange) {
        this.dataRange2_ = dataRange;
    }

    public int column(int x) {
        return (x - this.insets_.left) / this.columnWidth_;
    }

    public int getColumnWidth() {
        return this.columnWidth_;
    }

    public void setOverlay(int i, ChartOverlay overlay) {
        int width;
        ChartOverlay replaced = null;
        if (i >= this.overlays_.size()) {
            this.addOverlay(overlay);
        } else {
            replaced = (ChartOverlay)this.overlays_.elementAt(i);
            this.overlays_.setElementAt(overlay, i);
        }
        if (replaced instanceof Log10Scale) {
            this.setLog10Scale(((Log10Scale)((Object)replaced)).getScale(), false);
        }
        if (overlay instanceof Log10Scale) {
            this.setLog10Scale(((Log10Scale)((Object)overlay)).getScale(), true);
        }
        if ((width = overlay.getItemWidth()) > this.itemWidth_) {
            this.itemWidth_ = width;
            this.columnWidth_ = this.itemWidth_ + this.spaceWidth_;
        } else if (replaced.getItemWidth() == this.itemWidth_) {
            this.recalculateItemWidth();
        }
    }

    public void recalculateItemWidth() {
        this.itemWidth_ = 1;
        for (int j = 0; j < this.overlays_.size(); ++j) {
            int width = ((ChartOverlay)this.overlays_.elementAt(j)).getItemWidth();
            if (width <= this.itemWidth_) continue;
            this.itemWidth_ = width;
        }
        this.columnWidth_ = this.itemWidth_ + this.spaceWidth_;
    }

    public boolean getIgnorePrimaryAxis() {
        return this.ignorePrimaryAxis_;
    }

    public void setIgnorePrimaryAxis(boolean ignore) {
        this.ignorePrimaryAxis_ = ignore;
        if (this.ignorePrimaryAxis_) {
            this.ignoreSecondaryAxis_ = false;
        }
    }

    public boolean getIgnoreSecondaryAxis() {
        return this.ignoreSecondaryAxis_;
    }

    public void setIgnoreSecondaryAxis(boolean ignore) {
        this.ignoreSecondaryAxis_ = ignore;
        if (this.ignoreSecondaryAxis_) {
            this.ignorePrimaryAxis_ = false;
        }
    }

    public Font getScaleFont() {
        return this.scaleFont_;
    }

    public void setScaleFont(Font font) {
        this.scaleFont_ = font;
    }

    public Font getTitleFont() {
        return this.titleFont_;
    }

    public void setTitleFont(Font font) {
        this.titleFont_ = font;
    }

    public int getTitleMargin() {
        return this.insets_.top;
    }

    public void setTitleMargin(int margin) {
        this.insets_.top = margin;
    }

    public int getBottomMargin() {
        return this.insets_.bottom;
    }

    public void setBottomMargin(int margin) {
        this.insets_.bottom = margin;
    }

    public int getLeftMargin() {
        return this.insets_.left;
    }

    public void setLeftMargin(int margin) {
        this.insets_.left = margin;
    }

    public double getScaleIncrement1(DataModel data) {
        double scaleIncrement = ParameterCalculator.calculateScaleIncrement(this.getDataRangeLow1(data), this.getDataRangeHigh1(data));
        scaleIncrement = this.internalProperties_.getProperty("scaleIncrement1", scaleIncrement);
        return scaleIncrement;
    }

    public void setScaleIncrement1(double increment) {
        if (increment <= 0.0) {
            return;
        }
        this.internalProperties_.addProperty("scaleIncrement1", new Double(increment));
    }

    public double getScaleIncrement2(DataModel data) {
        double scaleIncrement = ParameterCalculator.calculateScaleIncrement(this.getDataRangeLow2(data), this.getDataRangeHigh2(data));
        scaleIncrement = this.internalProperties_.getProperty("scaleIncrement2", scaleIncrement);
        return scaleIncrement;
    }

    public void setScaleIncrement2(double increment) {
        if (increment <= 0.0) {
            return;
        }
        this.internalProperties_.addProperty("scaleIncrement2", new Double(increment));
    }

    public double getDataRangeLow1(DataModel data) {
        DataRange dataRange = this.dataRange1_ != null ? this.dataRange1_ : (this.dataRange2_ != null ? this.dataRange2_ : new AllRowsDataRange(false));
        double dataLow = dataRange.low(data);
        double low = this.internalProperties_.getProperty("dataRangeLow1", dataLow);
        if (low > dataLow) {
            low = dataLow;
        }
        return low;
    }

    public void setDataRangeLow1(double low) {
        this.internalProperties_.addProperty("dataRangeLow1", new Double(low));
    }

    public double getDataRangeLow2(DataModel data) {
        DataRange dataRange = this.dataRange2_ != null ? this.dataRange2_ : (this.dataRange1_ != null ? this.dataRange1_ : new AllRowsDataRange(false));
        double dataLow = dataRange.low(data);
        double low = this.internalProperties_.getProperty("dataRangeLow2", dataLow);
        if (low > dataLow) {
            low = dataLow;
        }
        return low;
    }

    public void setDataRangeLow2(double low) {
        this.internalProperties_.addProperty("dataRangeLow2", new Double(low));
    }

    public double getDataRangeHigh1(DataModel data) {
        DataRange dataRange = this.dataRange1_ != null ? this.dataRange1_ : (this.dataRange2_ != null ? this.dataRange2_ : new AllRowsDataRange(false));
        double dataHigh = dataRange.high(data);
        double high = this.internalProperties_.getProperty("dataRangeHigh1", dataHigh);
        if (high < dataHigh) {
            high = dataHigh;
        }
        return high;
    }

    public void setDataRangeHigh1(double high) {
        this.internalProperties_.addProperty("dataRangeHigh1", new Double(high));
    }

    public double getDataRangeHigh2(DataModel data) {
        DataRange dataRange = this.dataRange2_ != null ? this.dataRange2_ : (this.dataRange1_ != null ? this.dataRange1_ : new AllRowsDataRange(false));
        double dataHigh = dataRange.high(data);
        double high = this.internalProperties_.getProperty("dataRangeHigh2", dataHigh);
        if (high < dataHigh) {
            high = dataHigh;
        }
        return high;
    }

    public void setDataRangeHigh2(double high) {
        this.internalProperties_.addProperty("dataRangeHigh2", new Double(high));
    }

    public void setDrawHeight(int height) {
        this.drawHeight_ = height;
    }
}

